/*------------------------------------------------------------------------------*
 * File Name: Fit1Peak.cpp														*
 * Creation: CPY  10/21/04													    *
 * Purpose: Origin C file for Fit Gaussian/Fit Lorentzian automation			*
 * Copyright (c) OriginLab Corp 2004, 2005										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * DG 4/13/05 FUNCTION_NAME_WITH_PREFIX											*
 *------------------------------------------------------------------------------*/
 
#include <origin.h>
#include "FitCommon.h"
#include "NLFitSession.h"

#ifdef _FOR_SMART_LOADING_ONLY
#include "analysis_utils.h"
#include <stats_utils.h>
#include "stats_guis.h"
#include "stats_operations.h"
#endif

#include "FitNL.h"

//#define PEAK_FUNCTION_NAMES			"Gauss|Lorentz|Asym2Sig|Beta|CCE|ECS|Extreme|GaussAmp|GaussMod|GCAS|Giddings|InvsPoly|LogNormal|Logistpk|PearsonVII|PsdVoigt1|PsdVoigt2|Voigt|Weibull3"

class OC_REGISTERED	Fit1Peak: public FitNL
{
protected:
	//virtual 
	string GetAnalysisName(int nOption)
	{
		return _L("Fit Single Peak");
	}
	// Virtual 
	string GetClassName() {return "Fit1Peak";}

	//virtual 
	bool GetCategoryFuncNames(TreeNode& trOperation, string& strCategory, string& strFunction, vector<string>& vsFilterList)
	{
		//if(NLFitBase::GetCategoryFuncNames(trOperation, strCategory, strFunction, vsFilterList))
		//	return true;
		strCategory = "Peak Functions";
		///DG 4/13/05 FUNCTION_NAME_WITH_PREFIX
		//strFunction = "Gauss";
		strFunction = "System: Gauss";
		///end FUNCTION_NAME_WITH_PREFIX
		return false;// indicate Category cannot be changed
	}
};

